/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.PointyRockConfig;
import corgiaoc.byg.util.noise.simplex.OpenSimplex2;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class PointyRockFeature
extends Feature<PointyRockConfig> {
    private static final int RADIUS = 8;
    private static final int BASE_HEIGHT_MULTIPLER = 96;
    private static final double NOISE_FREQUENCY_1 = 0.013;
    private static final double NOISE_FREQUENCY_2 = 0.026;
    private static final double NOISE_RANGE = 1.5;
    private static final double EFFECTIVE_HEIGHT_MULTIPLIER = 0.015625;
    private static final double NOISE_OFFSET_X = 0.45534180126147955;
    private static final double NOISE_OFFSET_Y = 0.12200846792814621;

    public PointyRockFeature(Codec<PointyRockConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator changedBlock, Random rand, BlockPos position, PointyRockConfig config) {
        long seed1 = rand.nextLong();
        long seed2 = rand.nextLong();
        int baseX = position.func_177958_n();
        int baseZ = position.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double effectiveConfiguredHeightMultiplier = config.getHeightMultiplier() * 0.015625;
        for (int z = -7; z < 8; ++z) {
            int worldZ = z + baseZ;
            for (int x = -7; x < 8; ++x) {
                int worldX = x + baseX;
                int distSq = z * z + x * x;
                if (distSq >= 64) continue;
                double falloff = 4096 - distSq * distSq;
                double noise = 1.5 - (double)Math.abs(OpenSimplex2.noise2(seed1, (double)x * 0.013 + 0.45534180126147955, (double)z * 0.013 + 0.12200846792814621)) - (double)Math.abs(OpenSimplex2.noise2(seed2, (double)x * 0.026 + 0.45534180126147955, (double)z * 0.026 + 0.12200846792814621)) * 0.5;
                noise *= falloff;
                int maximumHeight = (int)(noise *= effectiveConfiguredHeightMultiplier);
                int terrainHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, worldX, worldZ);
                if (maximumHeight <= terrainHeight) continue;
                mutable.func_181079_c(worldX, maximumHeight, worldZ);
                for (int y = maximumHeight; y >= terrainHeight; --y) {
                    mutable.func_185336_p(y);
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }
}

